//
//  MedicalPackageCell.m
//  as350b3e
//
//  Created by Vadim Dagman on 4/3/14.
//
//

#import "MedicalPackageCell.h"
#import "MedicalPackageTVController.h"
#import "MedicalPackage.h"
#import "CommonDefs.h"
#import "UtilityCategories.h"

@implementation MedicalPackageCell {
    
    __weak IBOutlet UIView *viewForItemsTable_;
    MedicalPackageTVController* packageController_;
    CGFloat minHeight_;
    __weak IBOutlet UITextField *packageNameTextField_;
    __weak IBOutlet UITextField *itemTextField_;
    __weak IBOutlet UITextField *armTextField_;
    __weak IBOutlet UILabel *totalWeightLabel_;
    __weak IBOutlet UILabel *totalArmLabel_;
    __weak IBOutlet UILabel *totalMomentLabel_;
    __weak IBOutlet UILabel *totalArmLatLabel_;
    __weak IBOutlet UILabel *totalMomentLatLabel_;
    __weak IBOutlet UILabel *weightUnitLabel_;
    __weak IBOutlet UILabel *armUnitLabel_;
    __weak IBOutlet UILabel *armLatUnitLabel_;
    __weak IBOutlet UILabel *momentUnitLabel_;
    __weak IBOutlet UILabel *momentLatUnitLabel_;
    __weak IBOutlet UIButton *selectButton_;
    __weak IBOutlet UIButton *addStationButton_;
    __weak IBOutlet NSLayoutConstraint *viewForTableHeightConstraint_;
    __weak IBOutlet NSLayoutConstraint *viewForTableWidthsConstraint_;
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        // Initialization code
    }
    return self;
}

- (void)awakeFromNib
{
    // Initialization code
    minHeight_ = self.frame.size.height;
    addStationButton_.layer.cornerRadius = 7;
    addStationButton_.layer.borderColor = [UIColor whiteColor].CGColor;
    addStationButton_.layer.borderWidth = 1;
    
}

- (void)setParentController:(UIViewController *)parentController {
    _parentController = parentController;
    self.packageController.package = _package;
    [self.packageController willMoveToParentViewController:_parentController];
    [viewForItemsTable_ addSubview:self.packageController.view];
    [parentController addChildViewController:self.packageController];
}

- (void)setPackage:(MedicalPackage *)package {
    [self removeObserverForPackage:_package];
    _package = package;
    [self addObserverForPackage:_package];
    
    self.packageController.package = package;
    viewForTableHeightConstraint_.constant = [self.packageController tableHeightForMedicalPackage:package];
    CGRect frame = self.packageController.view.frame;
    frame.size.height = viewForTableWidthsConstraint_.constant;
    self.packageController.view.frame = frame;
    frame = self.contentView.frame;
    frame.size.height = [self cellHeightForPackage:package];
    self.contentView.frame = frame;
    //NSLog(@"SetPackage: %@ %F %f %F", package.packageName, viewForTableHeightConstraint_.constant, self.packageController.view.frame.size.height, self.frame.size.height);
    
    packageNameTextField_.text = package.packageName;
    armTextField_.text = package.longitudinal;
    itemTextField_.text = package.lateral;
    totalWeightLabel_.text = [NSString stringFromFloat:_package.totalWeight]; NSLog(@"totalWeightLabel_.text: %@", totalWeightLabel_.text);
    totalArmLabel_.text = [NSString stringFromFloat:_package.totalArm];
    totalArmLatLabel_.text = [NSString stringFromFloat:_package.totalArmLat];
    totalMomentLabel_.text = [NSString stringFromFloat:_package.totalMoment];
    totalMomentLatLabel_.text = [NSString stringFromFloat:_package.totalMomentLat];
    
     package.weightInKg = 1;  // Claus
    
    
    if (package.weightInKg) {
        weightUnitLabel_.text = @"(kg)";
        armLatUnitLabel_.text = armUnitLabel_.text = @"(mm)";
        momentUnitLabel_.text = momentLatUnitLabel_.text = @"(kg*mm)";
    } else {
        weightUnitLabel_.text = @"(lbs)";
        armLatUnitLabel_.text = armUnitLabel_.text = @"(in)";
        momentUnitLabel_.text = momentLatUnitLabel_.text = @"(lbs*in)";
    }
    
    selectButton_.selected = _package.selected;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    viewForTableWidthsConstraint_.constant = self.frame.size.width;
    NSLog(@"Set MyView width: %F", viewForTableWidthsConstraint_.constant);
    if (_package) {
        CGRect rect = self.packageController.view.frame;
        rect.size.height = viewForTableHeightConstraint_.constant;
        if ((int)viewForTableHeightConstraint_.constant == 1728) {
            NSLog(@"Set self.packageController height: %f", viewForTableHeightConstraint_.constant);
        }
        self.packageController.view.frame = rect;
        NSLog(@"Set self.packageController height: %f", viewForTableHeightConstraint_.constant);
    }
   
//    [self.packageController.tableView reloadData];
}

- (void)setFrame:(CGRect)frame {
    [super setFrame:frame];
}

- (void)setBounds:(CGRect)bounds {
    [super setBounds:bounds];
}

- (MedicalPackageTVController*)packageController {
    if (!packageController_) {
        packageController_ = [_parentController.storyboard instantiateViewControllerWithIdentifier:@"medicalPackageController"];
        packageController_.delegate = self;
    }
    return packageController_;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated
{
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (CGFloat)cellHeightForPackage:(MedicalPackage *)package {
    return minHeight_ + [self.packageController tableHeightForMedicalPackage:package];
}

- (void)addObserverForPackage:(MedicalPackage*)package {
    [package addObserver:self forKeyPath:@"totalWeight" options:NSKeyValueObservingOptionNew context:nil];
    [package addObserver:self forKeyPath:@"totalArm" options:NSKeyValueObservingOptionNew context:nil];
    [package addObserver:self forKeyPath:@"totalArmLat" options:NSKeyValueObservingOptionNew context:nil];
    [package addObserver:self forKeyPath:@"totalMoment" options:NSKeyValueObservingOptionNew context:nil];
    [package addObserver:self forKeyPath:@"totalMomentLat" options:NSKeyValueObservingOptionNew context:nil];
}

- (void)removeObserverForPackage:(MedicalPackage*)package {
    if (_package) {
        [package removeObserver:self forKeyPath:@"totalWeight"];
        [package removeObserver:self forKeyPath:@"totalArm"];
        [package removeObserver:self forKeyPath:@"totalArmLat"];
        [package removeObserver:self forKeyPath:@"totalMoment"];
        [package removeObserver:self forKeyPath:@"totalMomentLat"];
    }
}

- (void) dealloc {
    [self removeObserverForPackage:_package];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context {
    totalWeightLabel_.text = [NSString stringFromFloat:_package.totalWeight];
    totalArmLabel_.text = [NSString stringFromFloat:_package.totalArm];
    totalArmLatLabel_.text = [NSString stringFromFloat:_package.totalArmLat];
    totalMomentLabel_.text = [NSString stringFromFloat:_package.totalMoment];
    totalMomentLatLabel_.text = [NSString stringFromFloat:_package.totalMomentLat];
}

#pragma mark- Actions

- (IBAction)selectPackageAction:(UIButton*)sender {
    sender.selected = !sender.selected;
    _package.selected = sender.selected;
    self.packageController.package = _package;
    [_delegate cellSizeChanged:self];
}

- (IBAction)deletePackageAction:(id)sender {
    UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:@"Are you sure you want to delete the complete package?" message:nil delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:@"Delete", nil];
    [alertView show];
}

- (IBAction)addStationAction:(id)sender {
    MedicalItem* item = [[MedicalItem alloc] init];
    item.selected = YES;
    [_package addItem:item];
    self.packageController.package = _package;
    [_delegate cellSizeChanged:self];
}

- (IBAction)editingEnded:(UITextField *)sender {
    _package.packageName = packageNameTextField_.text;
    _package.longitudinal = itemTextField_.text;
    _package.lateral = armTextField_.text;
    [_package serialize];
}

- (IBAction)editingBegin:(id)sender {
    [[NSNotificationCenter defaultCenter] postNotificationName:TEXT_FIELD_WILL_BEGIN_EDITING object:sender];
}

#pragma mark- MedicalPackageControllerDelegate

- (void)sizeChanged {
    [_delegate cellSizeChanged:self];
}

#pragma mark- UIAlertViewDelegate

- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex {
    if (buttonIndex != alertView.cancelButtonIndex) {
        [_delegate cellDeleted:self];
    }
}
@end
